<?php
error_reporting(E_ALL^(E_NOTICE|E_WARNING));
ini_set('display_errors',1);
error_reporting(0);
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-1">
      <div class="col-sm-12 text-center">
        <h1 class="m-0 text-dark font-weight-bold">Kartu Tagihan</h1>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
        <!-- Default box -->
        <div class="card shadow-lg rounded-lg">
          <div class="card-header bg-gradient-primary text-white">
            <h3 class="card-title">Detail Kartu Tagihan</h3>
            <div class="card-tools">
              <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                <i class="fas fa-minus"></i>
              </button>
              <button type="button" class="btn btn-tool" data-card-widget="remove" title="Remove">
                <i class="fas fa-times"></i>
              </button>
            </div>
          </div>

          <!-- /.card-header -->
          <div class="card-body">
            <?php          
            $kode = $_SESSION['kode'];
            if(isset($_POST['rekening'])){
              $rekening = $_POST['rekening'];
              $where = $rekening == 'Pilih' ? "where id='0'" : "where id='$rekening'";
            } else {
              $rekening = '';
              $where = "where id='$rekening'";
            }
            ?>
            <form role="form" id="quickForm" action="" method="POST">
              <div class="form-group row">
                <label for="rekening" class="col-2 col-form-label">Rekening</label>
                <div class="col-sm-3">
                  <input type="text" id="rekening" name="rekening" class="form-control" maxlength="16" value="<?php echo isset($_POST['rekening']) ? $_POST['rekening'] : ''; ?>" placeholder="Masukkan Rekening" autofocus>
                </div>
                <button type="submit" name="proses" class="btn btn-primary ml-3" value="Cari">
                  <i class="fas fa-search"></i> Cari
                </button>
              </div>
            </form>

            <hr>

            <?php
            function buatrp($angka){
              return number_format($angka, 2, '.', ',');
            }

            include 'koneksi.php';
            require './kalenderhijriah.php';

            $querya = "SELECT tgl, nama, alamat, rtrw FROM registrasi $where";
            $query = mysqli_query($koneksi, $querya);

            $nama = $alamat = $rtrw = $tgl = "";
            if(mysqli_num_rows($query)){
              while ($data = mysqli_fetch_assoc($query)) {
                $tgl = $data['tgl'];
                $nama = $data['nama'];
                $alamat = $data['alamat'];
                $rtrw = $data['rtrw'];
              }
            }
            if(isset($_POST['rekening'])){
              echo "<h5><strong>Nama:</strong> $nama</h5>";
              echo "<h5><strong>Alamat:</strong> $alamat, $rtrw</h5>";
              echo "<h5><strong>Tanggal:</strong> " . (isset($hijri) ? sprintf('%02d', $hijri[1]) . '-' . $calendar->monthName($hijri[0]) . '-' . $hijri[2] : '') . "</h5>";
              ?>

              <table id="example3" class="table table-striped table-bordered">
                <thead>
                  <tr class="bg-info text-white">
                    <th>No</th>
                    <th>Tanggal</th>
                    <th>No Bukti</th>
                    <th>Tagihan</th>
                    <th>Bayar</th>
                    <th>Keterangan</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  $queryp = "
                  SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'bulanan' as source_table 
                  FROM bulanan WHERE id='$rekening'
                  UNION ALL
                  SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'kitab' as source_table 
                  FROM kitab WHERE id='$rekening'
                  UNION ALL
                  SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'seragam' as source_table 
                  FROM seragam WHERE id='$rekening'
                  ORDER BY tgl ASC";
                  $query = mysqli_query($koneksi, $queryp);
                  $t_kwajiban = $t_bayar = 0;

                  if(mysqli_num_rows($query)){
                    $no = 1;
                    while ($data = mysqli_fetch_assoc($query)) {
                      $tgl = $data['tgl'];
                      $no_bukti = $data['no_bukti'];
                      $kewajiban = $data['kewajiban'];
                      $bayar = $data['bayar'];
                      $keterangan = $data['keterangan'];

                      $t_kwajiban += $kewajiban;
                      $t_bayar += $bayar;
                      ?>
                      <tr>
                        <td class="text-center"><?php echo $no++; ?></td>
                        <td class="text-center"><?php echo date('d-m-Y', strtotime($tgl)); ?></td>
                        <td class="text-center"><?php echo $no_bukti; ?></td>
                        <td class="text-right"><?php echo buatrp($kewajiban); ?></td>
                        <td class="text-right"><?php echo buatrp($bayar); ?></td>
                        <td><?php echo $keterangan; ?></td>
                      </tr>
                      <?php
                    }
                  }
                  ?>
                </tbody>
                <tfoot>
                  <tr class="font-weight-bold">
                    <th colspan="3" class="text-center">Total</th>
                    <th class="text-right"><?php echo buatrp($t_kwajiban); ?></th>
                    <th class="text-right"><?php echo buatrp($t_bayar); ?></th>
                    <th></th>
                  </tr>
                </tfoot>
              </table>
              <?php
            }
            ?>
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->
    </div>
    <!-- /.row -->
  </div>
</section>
<!-- /.content -->
